<?php
defined('BASEPATH') or exit('No direct script access allowed');

class Certificadores extends MY_Controller
{
    public function __construct()
    {
        parent::__construct();

        if (!$this->loggedIn) {
            $this->session->set_userdata('requested_page', $this->uri->uri_string());
            $this->sma->md('login');
        }

        $this->lang->admin_load('certificadores', $this->Settings->user_language);
        $this->load->library('form_validation');
        $this->load->admin_model('Certificadores_model', 'certificadores');
    }

    public function index()
    {
        $this->sma->checkPermissions();

        $this->data['certificadores'] = $this->certificadores->getAllCertificadores();

        if (!$this->data['certificadores']) {
            $this->data['error'] = 'No hay certificadores disponibles.';
        }

        $bc   = [['link' => base_url(), 'page' => lang('home')], ['link' => '#', 'page' => lang('certificadores')]];
        $meta = ['page_title' => lang('certificadores'), 'bc' => $bc];

        $this->page_construct('certificadores/index', $meta, $this->data);
    }

    public function getCertificadores()
    {
        $this->sma->checkPermissions('index');

        $this->load->library('datatables');
        $this->datatables
            ->select('id, nombre, descripcion, api_path, api_key, activo')
            ->from('sma_certificadores') // Tabla correcta
            ->add_column('Actions', "<div class=\"text-center\">
                <a class=\"tip\" title='" . $this->lang->line('edit_certificador') . "' href='" . admin_url('certificadores/edit/$1') . "' data-toggle='modal' data-target='#myModal'><i class=\"fa fa-edit\"></i></a>
                <a href='#' class='tip po' title='<b>" . $this->lang->line('delete_certificador') . "</b>' data-content=\"<p>" . lang('r_u_sure') . "</p>
                <a class='btn btn-danger po-delete' href='" . admin_url('certificadores/delete/$1') . "'>" . lang('i_m_sure') . "</a>
                <button class='btn po-close'>" . lang('no') . "</button>\" rel='popover'><i class=\"fa fa-trash-o\"></i></a></div>", 'id');

        echo $this->datatables->generate();
    }
}
